#include "HT66F3185.h"
#define PWMDuty_Base  50       //PWM Duty up or down 5%
//#define PWMDuty_Max   1024     //PWM Duty 100%
#define PWMDuty_Max   1000     //PWM Duty 98%
#define PWMDuty_Min   0       //PWM Duty 0%

bit direc_flag;            //direc_flag=0:PWM Duty up; direc_flag=1:PWM Duty down;					  
unsigned int PWM_COUNT;    //PWM Count
unsigned int PWM_Duty;     //PWM Duty 


//////////function/////////////
void ISR_STM();
void STM_init();


//---------------------------------
// main program
//---------------------------------
void main()
{
	PWM_COUNT =0;
	PWM_Duty = 0;         //PWM duty=0% 
    direc_flag = 0;       //PWM Duty up 
    
   	_wdtc = 0x53;          //enable wdtc
    
    STM_init();           //PTM init
	while(1)
    {
    	_clrwdt();		  //clear wdtc
    }
  
}

//---------------------------------
// PTM Initial procedure
//---------------------------------
void STM_init()
{
    _pbs05=0;
    _pbs04=1;       //PB2 as STP
    _stmc0=0x20;    //f=FH/16,, TM1=Off state
    _stmc1=0xa8;    //PWM_Mode, Active high, Non-invert,counter clear when comparator P match      
 	_stmrp=0x04;   //PWM Period=488Hz,PWM Period=(FH/16)/(CCRP)=(8M/16)/1024
    _stmal=0;
    _stmah=0;       //PWM duty=0%
    
    _mf0e=1; 	    // Multifunction 0 interrupt enable
    _stmpe=1;       // STM comparator P interrupt enable
//  _stmae=1;       // STM comparator A interrupt enable
   
	_stmpf=0;       // clear STM comparator P interrupt flag
    _stmaf=0;       // clear STM comparator A interrupt flag
    _mf0f=0;        // clear Multifunction 0 interrupt flag
    _emi=1;         //interrupt mask enable
   
    _ston=1;        //Let STM start to run
}


//-----------------------------------
// PWM Interrupt Service Routine
//-----------------------------------
void __attribute((interrupt(0x0c))) ISR_STM(void)
{   
	if(_stmpf==1)   //PWM Period
	{
    	_stmpf=0;
   	    PWM_COUNT++; 
    }
  	
    if(_stmaf==1)   //PWM duty	
    {
	    _stmaf=0;
    }	
				
    if((PWM_COUNT == 80) && (direc_flag == 0))             //direc_flag=0,PWM duty up;
    {                              
    	PWM_COUNT = 0;
        PWM_Duty = PWM_Duty + PWMDuty_Base;                //PWM duty up 5%
        if(PWM_Duty >= PWMDuty_Max) PWM_Duty = PWMDuty_Max;
    	if(PWM_Duty == PWMDuty_Max) 
        {
        	direc_flag = 1;                                //if PWM duty=100%Athen PWM duty down
       		GCC_DELAY(1000);
       		GCC_DELAY(1000);
       		
        }
        _stmal= (PWM_Duty & 0xff);    
   		_stmah= (PWM_Duty & 0xff00) >> 8;      
    }
    if((PWM_COUNT == 80) && (direc_flag == 1))             //direc_flag=0,PWM duty down;
    {                             
        PWM_COUNT = 0;
        if(PWM_Duty > PWMDuty_Base) PWM_Duty = PWM_Duty - PWMDuty_Base;  //PWM duty down 5%
        else PWM_Duty = PWMDuty_Min;
        if(PWM_Duty == PWMDuty_Min) 
        {
        	direc_flag = 0;                                //if PWM duty=0%Athen PWM duty up
           GCC_DELAY(1000);
           GCC_DELAY(1000);
        }
        _stmal= (PWM_Duty & 0xff);    
   		_stmah= (PWM_Duty & 0xff00) >> 8;      
    } 
}

